/*==============================================================================
 step0615 - merge in urbanization.do
 
==============================================================================*/

clear
set more off

cd "$insheet_files"
import excel "urbanization.xls", first cellrange(A4:AK385) sheet("RESULT")


tempfile urban_temp1
save `urban_temp1.dta'

keep if EU_flag==0 

keep nuts country total* urban_pop*

tempfile states_provinces
save `states_provinces.dta'

collapse (sum) total_pop_* urban_pop*, by(country)

gen nuts= "Entire U.S." if country=="US"
replace nuts = "Canada" if country=="CA"

append using `states_provinces.dta'

tempfile urban_us_ca
save `urban_us_ca.dta'

use `urban_temp1.dta'

keep if EU_flag==2

keep nuts country total* urban_pop*

tempfile nuts2
save `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) total_pop_* urban_pop* (first) country, by(nuts1) 

rename nuts1 nuts

tempfile nuts1
save `nuts1.dta'

collapse (sum) total_pop_* urban_pop*, by(country) 

gen nuts = country

append using `nuts1.dta'
append using `nuts2.dta'
append using `urban_us_ca.dta'

*****
gen region=.
replace region=	840004	if nuts	== "US: AL"
replace region=	840009	if nuts	== "US: AK"
replace region=	840008	if nuts	== "US: AZ"
replace region=	840005	if nuts	== "US: AR"
replace region=	840010	if nuts	== "US: CA"
replace region=	840008	if nuts	== "US: CO"
replace region=	840001	if nuts	== "US: CT"
replace region=	840003	if nuts	== "US: DE"
replace region=	840003	if nuts	== "US: DC"
replace region=	840003	if nuts	== "US: FL"
replace region=	840003	if nuts	== "US: GA"
replace region=	840009	if nuts	== "US: HI"
replace region=	840008	if nuts	== "US: ID"
replace region=	840006	if nuts	== "US: IL"
replace region=	840006	if nuts	== "US: IN"
replace region=	840007	if nuts	== "US: IA"
replace region=	840007	if nuts	== "US: KS"
replace region=	840004	if nuts	== "US: KY"
replace region=	840005	if nuts	== "US: LA"
replace region=	840001	if nuts	== "US: ME"
replace region=	840003	if nuts	== "US: MD"
replace region=	840001	if nuts	== "US: MA"
replace region=	840006	if nuts	== "US: MI"
replace region=	840007	if nuts	== "US: MN"
replace region=	840004	if nuts	== "US: MS"
replace region=	840007	if nuts	== "US: MO"
replace region=	840008	if nuts	== "US: MT"
replace region=	840007	if nuts	== "US: NE"
replace region=	840008	if nuts	== "US: NV"
replace region=	840001	if nuts	== "US: NH"
replace region=	840002	if nuts	== "US: NJ"
replace region=	840008	if nuts	== "US: NM"
replace region=	840002	if nuts	== "US: NY"
replace region=	840003	if nuts	== "US: NC"
replace region=	840007	if nuts	== "US: ND"
replace region=	840006	if nuts	== "US: OH"
replace region=	840005	if nuts	== "US: OK"
replace region=	840009	if nuts	== "US: OR"
replace region=	840002	if nuts	== "US: PA"
replace region=	840001	if nuts	== "US: RI"
replace region=	840003	if nuts	== "US: SC"
replace region=	840007	if nuts	== "US: SD"
replace region=	840004	if nuts	== "US: TN"
replace region=	840005	if nuts	== "US: TX"
replace region=	840008	if nuts	== "US: UT"
replace region=	840001	if nuts	== "US: VT"
replace region=	840003	if nuts	== "US: VA"
replace region=	840009	if nuts	== "US: WA"
replace region=	840003	if nuts	== "US: WV"
replace region=	840006	if nuts	== "US: WI"
replace region=	840008	if nuts	== "US: WY"

tempfile precollapse
save `precollapse.dta'

keep if region!=.

collapse (sum) total* urban*, by(region)

gen nuts=""
replace nuts = "US: New England" if region== 840001 
replace nuts = "US: Middle Atlantic States" if region==840002
replace nuts = "US: South Atlantic" if region==840003	
replace nuts = "US: East South Central" if region==840004	
replace nuts = "US: West South Central" if region==840005	
replace nuts = "US: East North Central" if region==840006	
replace nuts = "US: West North Central" if region==840007	
replace nuts = "US: Rocky Mountain state" if region==840008	
replace nuts = "US: Northwest" if region==840009
replace nuts = "US: California" if region==840010

gen country="US"
drop region
append using `precollapse.dta'

replace nuts = 	"CA: Prince Edward Island" if nuts=="PE" & country=="CA"
replace nuts =  "CA: Nova Scotia"  if nuts=="NS" & country=="CA"
replace nuts =  "CA: New Brunswick"  if nuts=="NB"  & country=="CA"
replace nuts =  "CA: Quebec"  if nuts=="QC"  & country=="CA"
replace nuts =  "CA: Ontario"  if nuts=="ON"  & country=="CA"
replace nuts =  "CA: Manitoba"  if nuts=="MB"  & country=="CA"
replace nuts =  "CA: Saskatchewan"  if nuts=="SK"  & country=="CA"
replace nuts =  "CA: Alberta" if nuts=="AB"  & country=="CA"
replace nuts =  "CA: British Columbia"  if nuts=="BC"  & country=="CA"
replace nuts =  "CA: Newfoundland and Labrador"  if nuts=="NL"  & country=="CA"

********************************************************************************

keep nuts country urban* total*
keep if country=="UK"|country=="SE"|country=="NL"|country=="IT"| ///
	country=="FR"|country=="ES"|country=="DK"|country=="DE"| ///
	country=="CH"|country=="BE"|country=="AT"|country=="FI"|country=="US"| ///
	country=="CA"

save "$dta_files/IC_urbanization", replace
